/* Author: Helen Wollan <h.e.wollan@sms.ed.ac.uk>
 * Updated: Thurs Sept 02 2004 by Helen Wollan
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.ip2.map;

import java.awt.Color;
import java.util.*;
import java.lang.reflect.Array;
import javax.swing.*;
import java.awt.event.*;
import java.awt.Component;

import com.bbn.openmap.Layer;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.event.*;
import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.LatLonPoint;

import ix.util.Util;
import ix.util.Parameters;
import ix.iface.util.CatchingActionListener;
import ix.icore.domain.PatternAssignment;

import ix.util.*;
import ix.icore.domain.*;
import ix.iface.util.*;


import ix.icore.process.event.*; 
import ix.icore.IXAgent;
import ix.util.lisp.*;
import ix.ip2.*;


public class IxPatternLayer extends OMGraphicHandlerLayer implements ProcessStatusListener {

    private Color patternColor = Color.black;
    private OMGraphicList omgraphics; 
    private Projection proj;
    private Hashtable patternlist;
    private Hashtable widthhash;
    private Hashtable sectorlist;
    private Ip2 agent;
    private int lineType = OMGraphic.LINETYPE_STRAIGHT;
    private double incr_size = 5; // default visibility in kilometers
    private int initdir1 = 0, initdir2 = 0;
    private Vector patternVector = new Vector();
    
    public IxPatternLayer() {
        super();
		omgraphics = (OMGraphicList)getList();
		patternlist = new Hashtable();
		widthhash = new Hashtable();
		sectorlist = new Hashtable();
		agent = (Ip2) IXAgent.getAgent();
		(agent.getModelManager()).addProcessStatusListener(this);
    }
    
	// initialise the properties of the layer
    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
    }

	// render the omgraphics on the map
    public void paint(java.awt.Graphics g) {
        omgraphics.render(g);
    }

	// repaint the omgraphics when the projection is changed by the user
    public void projectionChanged(ProjectionEvent pe) {
        Projection oldProj = proj;
        proj = setProjection(pe);
        if (proj != null) {
            getList().generate(proj);
            repaint();
        }
        else
            proj = oldProj;
    
        fireStatusUpdate(LayerStatusEvent.FINISH_WORKING);
    }   

    public OMGraphicList getList() {
        OMGraphicList list = super.getList();
        if (list == null) {
            list = new OMGraphicList();
            super.setList(list);
        }
        return list;
    }

	// return the list of the omgraphics
    public void reset(){
        for(int i=omgraphics.size()-1;i>=0;i--){
            omgraphics.removeOMGraphicAt(i);
        }
        getList().generate(proj);
        repaint();
        patternlist.clear();
    }

    // ProcessStatusListener 
    // this is where code goes to put things on map   

    public void stateChange(ProcessStatusEvent event, Map delta) {
		try{
	    	for (Iterator i = delta.entrySet().iterator(); i.hasNext();) {
				Map.Entry e = (Map.Entry)i.next();
				LList pattern = (LList)e.getKey(); 
	
				LList property = ((LList)pattern.clone()).delete(pattern.get(1));

				if (((property.get(0)).toString()).equals("pattern")) {
					
					Vector points = new Vector();
					String sector = (pattern.get(1)).toString(); // the sector name
		    		OMPoly path = null;
		    		LList value = (LList) e.getValue();
		    		float pointsF[] = new float[value.size()*2];
					
					// reading through the points and adding them to a float[] array
		    		for(int x=0;x<value.size();x++){
						LList point = (LList) value.get(x);
						pointsF[2*x] = Float.parseFloat((point.get(0)).toString());
						pointsF[2*x+1] = Float.parseFloat((point.get(1)).toString());
		    		}
					
					path = new OMPoly(pointsF,OMGraphic.DECIMAL_DEGREES,lineType);
					path.setLinePaint(patternColor);	
					omgraphics.add(path);
					// add the OMPoly to the hashtable for storage
					patternlist.put(sector,path);
		    		
		    	// check if the property is a sector and isn't already in the patternlist.  Construct
		    	// a pattern if there is none already constructed.
		    	} else if ((((property.get(0)).toString()).equals("sector")) && !(patternlist.containsKey((pattern.get(1)).toString()))) {
			    	
			    	String sector = (pattern.get(1)).toString(); // the sector name
		    		LList value = (LList) e.getValue();
		    		int numVerts = value.size();
		    		patternVector = new Vector();
		    		sectorlist.put(sector, value);
		    		// define the pattern for the sector
		    		if (widthhash.containsKey(sector)) {
			    		incr_size = ((Double)widthhash.get(sector)).doubleValue();
			    	} else {
			    		incr_size = 5; // resetting to the default
			    	}
		    		patternVector = splitPolygon(sector, value);
		    		addPattern(patternVector, sector);
				} else if (((property.get(0)).toString()).equals("trackWidth")) {
	    			// the constraint is the track width of the sector
	    			// put the probability in a hashtable with the sector name as the key
	    			String sector = (pattern.get(1)).toString();
	    			Double wvalue = (Double) e.getValue();
	    			if (patternlist.containsKey(sector)) {
	    				incr_size = wvalue.doubleValue();
	    				patternVector = new Vector();
	    				// remove old
	    				omgraphics.remove((OMPoly)patternlist.get(sector));
				    	patternlist.remove(sector);
				    	// add new
	    				patternVector = splitPolygon(sector, ((LList) sectorlist.get(sector)));
	    				addPattern(patternVector, sector);
	    			}
	    			widthhash.put(sector, wvalue);
	    		}
				getList().generate(proj);
				repaint();
	    	}
		} catch(Exception exception) {
			System.err.println("Syntax error in pattern: "); 
			exception.printStackTrace();
		}
    }

	// method to deal with constraints being deleted from IX.
    public void stateDeletion(ProcessStatusEvent event, java.util.Map delta){
	for (Iterator i = delta.entrySet().iterator(); i.hasNext();) {
	    Map.Entry e = (Map.Entry)i.next();
	    LList pattern = (LList)e.getKey(); 
	    LList property = ((LList)pattern.clone()).delete(pattern.get(1));

	    if( ((property.get(0)).toString()).equals("pattern") ) {
	        if (patternlist.containsKey(pattern.get(1))) {
		    	omgraphics.remove((OMPoly)patternlist.get(pattern.get(1)));
		    	patternlist.remove(pattern.get(1));
            	getList().generate(proj);
             	repaint();
			}
	    }
	    getList().generate(proj);
		repaint();
    }
    }

    public void newBindings(ProcessStatusEvent e, java.util.Map bindings){}
    public void statusUpdate(ProcessStatusEvent e){}
    
    // splits the polygon into convex polygons by checking the internal angles and drawing
    // interior lines to the closest vertex if the interior angle is greater than 180 degrees
    // recursively iterates through the polygon until all sub-polygons are also convex
    private Vector splitPolygon(String sectorname, LList vertices) {
    	float[] pointsF = new float[vertices.size() * 2];
		for (int x = 0; x < vertices.size(); x++){
			LList point = (LList) vertices.get(x);
			pointsF[2*x] = Float.parseFloat((point.get(0)).toString());
			pointsF[2*x+1] = Float.parseFloat((point.get(1)).toString());
		}
		
		// check internal angles - to do so, need to find which direction
		// is internal.
		float vertex[] = new float[2];
		float adj1[] = new float[2];
		float adj2[] = new float[2];
		float p[] = new float[2];
		double bearinga1v, bearingva2;
		double dist = Double.MAX_VALUE;
		int v = pointsF.length;
		Vector newpoly = new Vector();
		Vector newpoly2 = new Vector();
		
		for (int i = 0; i < vertices.size(); i++) {
			// getting the vertex lat/lon coords
			vertex[0] = pointsF[2*i];
			vertex[1] = pointsF[2*i + 1];
			
			// get the vertex before the one in question
			if (i == 0) {
				adj1[0] = pointsF[2*(vertices.size() - 2)];
				adj1[1] = pointsF[2*(vertices.size() - 2) + 1];
			} else {
				adj1[0] = pointsF[2*i - 2];
				adj1[1] = pointsF[2*i - 1];
			}
			
			// get the vertex after the one in question
			if (i == (vertices.size() - 1)) {
				adj2[0] = pointsF[0];
				adj2[1] = pointsF[1];
			} else {
				adj2[0] = pointsF[2*i + 2];
				adj2[1] = pointsF[2*i + 3];
			}
			
			bearinga1v = calcBearing(vertex, adj1);
			bearingva2 = calcBearing(vertex, adj2);
			
			// check the cases and calculate the convex point accordingly
			// algorithm uses this to then check if the interior angle is convex or concave
			if ((bearinga1v <= 0 && bearingva2 <= 0) || (bearinga1v > 0 && bearingva2 > 0)) {
				// calculate the convex dest point
				if (bearingva2 < bearinga1v) {
					p = calculateDestPoint(vertex, ((bearingva2 - bearinga1v) / 2));
				} else {
					p = calculateDestPoint(vertex, ((bearinga1v - bearingva2) / 2));
				}
			} else if (bearinga1v <= 0 && bearingva2 > 0 && bearingva2 < (Math.PI/2)) {
				p = calculateDestPoint(vertex, ((bearingva2 + bearinga1v) / 2));
			} else if (bearinga1v <= 0 && bearingva2 > 0 && bearingva2 >= (Math.PI/2)) {
				p = calculateDestPoint(vertex, ((2*Math.PI - (bearingva2 - bearinga1v)) / 2));
			} else if (bearingva2 < 0 && bearinga1v >= 0 && bearinga1v < (Math.PI/2)) {
				p = calculateDestPoint(vertex, ((bearinga1v + bearingva2) / 2));
			} else if (bearingva2 < 0 && bearinga1v >= 0 && bearinga1v >= (Math.PI/2)) {
				p = calculateDestPoint(vertex, ((2*Math.PI - (bearinga1v + bearingva2)) / 2));
			}
			
			// check if the convex dest point is in poly... if not, need to split at the vertex
			// to split at the vertex, calculate the shortest distance to another vertex not adj1 or adj2
			// make sure the line is within the existing poly by verifying no existing vertices
			// in the polygon are inside the new one.
			
			if (pointInPolygon(pointsF, p[0], p[1])) {
				int pl = pointsF.length - 2;
				for (int j = 0; j < pl; j++) {
					// check that point isn't vertex, adj1, or adj2)
					if ((pointsF[j] != vertex[0] && pointsF[j+1] != vertex[1]) && (pointsF[j] != adj1[0] && pointsF[j+1] != adj1[1]) && (pointsF[j] != adj2[0] && pointsF[j+1] != adj2[1])) {
						double d = Geo.distanceKM((new Float(vertex[0])).doubleValue(), (new Float(vertex[1])).doubleValue(), (new Float(pointsF[j])).doubleValue(), (new Float(pointsF[j+1])).doubleValue());
						
						if (d < dist) {
							dist = d;
							v = j;
						}
					}
					j++;
				}
				
				// create the new poly of all points between 2*i and v
				if (v == pointsF.length) {
					// poly is a triangle
					Vector pv = definePattern(sectorname, vertices);
					patternVector = mergeVectors(pv, patternVector);
			    	return patternVector;
				} else if (v < (2*i)) {
					// creating the 2 new polygons accordingly
					newpoly.addElement(new Float(pointsF[2*i]));
					newpoly.addElement(new Float(pointsF[2*i+1]));
					for (int k = v; k <= (2*i); k = k+2) {
						newpoly.addElement(new Float(pointsF[k]));
						newpoly.addElement(new Float(pointsF[k+1]));
					}
					newpoly2.addElement(new Float(pointsF[v]));
					newpoly2.addElement(new Float(pointsF[v+1]));
					
					for (int k = 2*i; k < pointsF.length-2; k = k+2) {
						newpoly2.addElement(new Float(pointsF[k]));
						newpoly2.addElement(new Float(pointsF[k+1]));
					}
					for (int k = 0; k <= v; k = k+2) {
						newpoly2.addElement(new Float(pointsF[k]));
						newpoly2.addElement(new Float(pointsF[k+1]));
					}
				} else {
					// creating the 2 new polygons accordingly					
					for (int k = (2*i); k<= v; k = k+2) {
						newpoly.addElement(new Float(pointsF[k]));
						newpoly.addElement(new Float(pointsF[k+1]));
					}
					newpoly.addElement(new Float(pointsF[2*i]));
					newpoly.addElement(new Float(pointsF[2*i+1]));
					
					newpoly2.addElement(new Float(pointsF[2*i]));
					newpoly2.addElement(new Float(pointsF[2*i+1]));
					for (int k = v; k < (pointsF.length - 2); k = k + 2) {
						newpoly2.addElement(new Float(pointsF[k]));
						newpoly2.addElement(new Float(pointsF[k+1]));
					}
					for (int k = 0; k < 2*i; k = k+2) {
						newpoly2.addElement(new Float(pointsF[k]));
						newpoly2.addElement(new Float(pointsF[k+1]));
					}
					if (!(newpoly2.elementAt(0)).equals(newpoly2.elementAt(newpoly2.size() - 2)) || !(newpoly2.elementAt(1)).equals(newpoly2.elementAt(newpoly2.size() - 1))) {
    					// making the polygon sector closed by adding the start point to the end
    					newpoly2.add(newpoly2.elementAt(0));
    					newpoly2.add(newpoly2.elementAt(1));
    				}
					
				}
				
				// making newpoly a LList and calling splitPolygon on it again
		    	LList temppoints = Lisp.NIL;
				LList temp;						
				for (int k = 0; k < newpoly.size(); k = k+2) {
					temp = Lisp.NIL;
					temp = Lisp.cons(newpoly.elementAt(k+1), temp);
					temp = Lisp.cons(newpoly.elementAt(k), temp);
					temppoints = Lisp.cons(temp, temppoints);
				}
				
				splitPolygon(sectorname, temppoints);
				
				// making newpoly2 a LList and calling splitPolygon on it
				if (newpoly2.size() != 0) {
			    	temppoints = Lisp.NIL;
					for (int k = 0; k < newpoly2.size(); k = k+2) {
						temp = Lisp.NIL;
						temp = Lisp.cons(newpoly2.elementAt(k+1), temp);
						temp = Lisp.cons(newpoly2.elementAt(k), temp);
						temppoints = Lisp.cons(temp, temppoints);
					}
					splitPolygon(sectorname, temppoints);
				}
				// done with the polygon
				return patternVector;				
				
			}
								
		}
		// defining the pattern for the convex polygon
		Vector pv = definePattern(sectorname, vertices);
		// merge the new pattern with the already existing pattern
		patternVector = mergeVectors(pv, patternVector);
    	return patternVector;	
    }
    
    // defines the search pattern for a given polygon indicated by the LList vertices
    public Vector definePattern(String sectorname, LList vertices) {
    	
    	Vector points = new Vector();
    	initdir1 = 0;
    	initdir2 = 0;
    	float[] pointsPF = new float[vertices.size() * 2];
		for (int x = 0; x < vertices.size(); x++){
			LList point = (LList) vertices.get(x);
			pointsPF[2*x] = Float.parseFloat((point.get(0)).toString());
			pointsPF[2*x+1] = Float.parseFloat((point.get(1)).toString());
		}
		
		// get the longest side of the polygon to start pattern on
		double[] dists = new double[vertices.size()];
		double[] max = new double[3]; // [dist, ind1, ind2];
		max[0] = 0; // initialise the dist to 0
		int x = 0;
		for (int k = 0; k < vertices.size(); k=k+2) {
			dists[x] = Geo.distanceKM((new Float(pointsPF[k])).doubleValue(), (new Float(pointsPF[k + 1])).doubleValue(), (new Float(pointsPF[k + 2])).doubleValue(), (new Float(pointsPF[k + 3])).doubleValue());
			
			// find the longest arc
			if (dists[x] > max[0]) {
				max[0] = dists[x];
				max[1] = k;
				max[2] = k + 2;
				
			}
			x++;
		}
		
		float[] intpoint = new float[2];
		float[] adjp1 = new float[2];
		float[] adjp2 = new float[2];
		float Pp[] = new float[2];
		float pointsI[] = new float[(vertices.size()-1) * 2];
		int dir = 0;
		double bearings[] = new double[2];
		double bearing = 0;

		// get all interior points and their direction functions
		// dir = 1: (bearing12 - bearing13) / 2
		// dir = 2: PI - (bearing12 + bearing13) / 2
		// dir = 3: (bearing13 - bearing12) / 2
		// dir = 4: (bearing12 + bearing13) / 2
		// dir = 5: PI - (bearing13 - bearing12) / 2
		for (int k = 0; k < (vertices.size() - 1) * 2; k = k + 2) {
			intpoint[0] = pointsPF[k];
			intpoint[1] = pointsPF[k + 1];
			
			// don't need to check that i is the last because pointsF last point equals first point
			adjp2[0] = pointsPF[k + 2];
			adjp2[1] = pointsPF[k + 3];
			
			if (k == 0) {
				adjp1[0] = pointsPF[vertices.size() * 2 - 4];
				adjp1[1] = pointsPF[vertices.size() * 2 - 3];
			} else {
				adjp1[0] = pointsPF[k - 2];
				adjp1[1] = pointsPF[k - 1];
			}
			
			bearings = calculateBisectBearing(intpoint, adjp1, adjp2);
			
			for (int j = 1; j < 6; j++) {
				if (j == 1) {
					bearing = (bearings[0] - bearings[1]) / 2;
				} else if (j == 5) {
					bearing = Math.PI - (bearings[0] + bearings[1]) / 2;
				} else if (j == 2) {
					bearing = (bearings[1] - bearings[0]) / 2;
				} else if (j == 3) {
					bearing = (bearings[0] + bearings[1]) / 2;
				} else if (j == 4) {
					bearing = Math.PI - (bearings[1] - bearings[0]) / 2;
				}
				
				Pp = calculateDestPoint(intpoint, bearing);
				
				if (pointInPolygon(pointsPF, Pp[0], Pp[1])) {
					pointsI[k] = Pp[0];
					pointsI[k + 1] = Pp[1];
					j = 6;
				}
			}
		}
		
		float newpoint[] = new float[2];
		float start1[] = new float[2];
		float start2[] = new float[2];
		float end1[] = new float[2];
		float end2[] = new float[2];
		int end1ind = (new Double(max[1])).intValue() - 2;
		int end2ind = (new Double(max[2])).intValue() + 2;
		
		// initialise the start and end points of both sides of the pattern
		start1[0] = pointsI[(new Double(max[1])).intValue()];
		start1[1] = pointsI[(new Double(max[1])).intValue() + 1];
		if ((new Double(max[1])).intValue() == 0) {
			end1[0] = pointsI[pointsI.length - 2];
			end1[1] = pointsI[pointsI.length - 1];
			end1ind = pointsI.length - 2;
		} else {
			end1[0] = pointsI[end1ind];
			end1[1] = pointsI[end1ind + 1];
		}
		
		double bearing1 = calcBearing(start1, end1);
		
		start2[0] = pointsI[(new Double(max[2])).intValue()];
		start2[1] = pointsI[(new Double(max[2])).intValue() + 1];
		if (end2ind == pointsI.length) {
			end2[0] = pointsI[0];
			end2[1] = pointsI[1];
			end2ind = 0;
		} else {
			end2[0] = pointsI[end2ind];
			end2[1] = pointsI[end2ind+1];
		}
		
		double bearing2 = calcBearing(start2, end2);
		
		points.addElement(new Float(start1[0]));
		points.addElement(new Float(start1[1]));
		
		newpoint[0] = start2[0];
		newpoint[1] = start2[1];
		
		//initialise the initdirs.
		lessThan(start1, end1, 1);
		lessThan(start2, end2, 2);
		
		
		boolean one = false, onegreater = false, same = false, twogreater = false;
		incr_size = incr_size*2; // double visibility because going past each point twice in pattern
		
		// while the new point is in the polygon, continue to generate the pattern
		while (pointInPolygon(pointsPF, newpoint[0], newpoint[1])) {
			
			points.addElement(new Float(newpoint[0]));
			points.addElement(new Float(newpoint[1]));
			onegreater = false;
			
			// check if start1 is past end1.  if so, change start1 to end1 and get the new end1
			if (!lessThan(start1, end1, 1)) {
				start1[0] = end1[0];
				start1[1] = end1[1];
				if (end1ind == 0) {
					end1[0] = pointsI[pointsI.length - 2];
					end1[1] = pointsI[pointsI.length - 1];
					end1ind = pointsI.length - 2;
				} else {
					end1[0] = pointsI[end1ind - 2];
					end1[1] = pointsI[end1ind - 1];
					end1ind = end1ind - 2;
				}
				
				bearing1 = calcBearing(start1, end1);
				initdir1 = 0;
				start1 = calculateDestPoint(start1, bearing1);
				if (newpoint != start2) newpoint = start1;				
				onegreater = true;
			}
			
			// check if start2 is past end2.  if so, change start2 to end2 and get the new end2
			if (!lessThan(start2, end2, 2)) {
				// start1 was also past end1.  so reached a vertex of the polygon and are now 
				// finished with the pattern definition
				if (onegreater) {
					incr_size = incr_size / 2;
					return points;
				}					
				start2 = end2;
				if (end2ind == (pointsI.length - 2)) {
					end2[0] = pointsI[0];
					end2[1] = pointsI[1];
					end2ind = 0;
				} else {
					end2[0] = pointsI[end2ind+2];
					end2[1] = pointsI[end2ind+3];
					end2ind = end2ind+2;
				}
				
				bearing2 = calcBearing(start2, end2);
				initdir2 = 0;
				start2 = calculateDestPoint(start2, bearing2);
				if (newpoint != start1) newpoint = start2;
				twogreater = true;
			}

			
			// before calculating the new dest points below, we need to recalulate the bearings
			// otherwise for a very large polygon, the point generated may be ouside the polygon
			// because the bearings change over long distances
			if (one) {
				// we're at the start1 vertex currently
				if (same) {
					// need to move to start2
					newpoint = start2;
					same = false;
					one = false;
				} else {
					// need to increment along the edge
					if (!onegreater)
						start1 = calculateDestPoint(start1, bearing1);
					newpoint = start1;
					start2 = calculateDestPoint(start2, bearing2);
					same = true;
				}
			} else {
				// we're at the start2 vertex currently
				if (same) {
					// need to move to start1
					newpoint = start1;
					same = false;
					one = true;
				} else {
					if (!twogreater)
						start2 = calculateDestPoint(start2, bearing2);
					newpoint = start2;
					start1 = calculateDestPoint(start1, bearing1);
					same = true;
				}
			}
			
		}
	
		incr_size = incr_size / 2; // return to the normal incr_size
		return points; // done generating the pattern - the point generated is outside the polygon
    }
    
    // add the pattern to I-X as a constraint
    private void addPattern(Vector points, String name) {
    	LList temppoints = Lisp.NIL;
		LList temp;
		for (int m = 0; m < points.size(); m = m + 2) {
			temp = Lisp.NIL;
			temp = Lisp.cons(points.elementAt(m + 1), temp);
			temp = Lisp.cons(points.elementAt(m), temp);
			temppoints = Lisp.cons(temp, temppoints);
		}
		
		sendConstraint(new PatternAssignment(Lisp.list(Symbol.intern("pattern"), Symbol.intern(name)), temppoints));
   	}
    
    // simple method to send a constraint to the IX agent.  Copied from WorldStateLayer
    private void sendConstraint(PatternAssignment pa){
        Vector v = new Vector();
        v.add(pa);
        Constraint c = new Constraint(Symbol.intern("world-state"),Symbol.intern("effect"),v);
        ((Ip2ModelManager)agent.getModelManager()).addConstraint(c);
    }    


	
    // code checks if point described by pointLat and pointLon is in the polygon polyVector
    // code modified from http://www.alienryderflex.com/polygon accessed 29 July 2004
    // returns true if the point is in the polygon, false otherwise
    private boolean pointInPolygon(float[] poly, float pointlat, float pointlon) {
    	int j = 0;
    	int k = 0;
    	int i = 0;
    	int polysize = poly.length / 2;
    	
    	int rcross = 0;
		int lcross = 0;
		boolean rstrad, lstrad;
		float x = 0;

    	float[] polylat = new float[polysize];
    	float[] polylon = new float[polysize];
    	for (i = 0; i < poly.length; i++) {
			polylat[k] = poly[i];
			polylon[k] = poly[i+1];
			k++;
			i++;
		} 
		
		for (i = 0; i < (polysize - 1); i++) {
			j++;
			if (j == polysize) j = 0;
			if (polylat[i] == pointlat && polylon[i] == pointlon) {
				return true; // point is a vertex
			}

			rstrad = (polylon[i] > pointlon) != (polylon[j] > pointlon);
			lstrad = (polylon[i] < pointlon) != (polylon[j] < pointlon);

			if (rstrad || lstrad) {
				x = pointlon * (float) ((float) (polylat[i] - polylat[j]) / (float) (polylon[i] - polylon[j])) - polylon[i] * (float) ((float) polylat[i] - polylat[j]) / (float)(polylon[i] - polylon[j]) + polylat[i];
    			if (rstrad && (x > pointlat)) {
      				rcross++;
    			}
    			if (lstrad && (x < pointlat)) {
      				lcross++;
    			}
  			}
		}	
		
		if ((rcross % 2) != (lcross % 2)) {
			return true; // on the edge
		} 
		if ((rcross % 2) == 1) {
  			return true; // inside the poly
		} else {
  			return false; // outside the poly, edge, or vertices
		}
    	
    }
	
	// calculates the bearing that bisects the two lines point1->point2 and point1->point3
	// points are [latitude, longitude] degrees
	// bearing returned is in radians
	private double[] calculateBisectBearing(float[] point1, float[] point2, float[] point3) {
		
		double bearing12 = calcBearing(point1, point2);
		
		double bearing13 = calcBearing(point1, point3);
    	
    	
    	double ans[] = new double[2];
    	ans[0] = bearing12;
    	ans[1] = bearing13;
    	
    	return ans;
    }
    
    // calculates the bearing between two latitude/longitude points on the map.  These points
    // are given in degrees and the bearign returned is in radians
    private double calcBearing(float[] point1, float[] point2) {
    	
		float lat1 = (new Float(Math.toRadians((new Float(point1[0]).doubleValue())))).floatValue();
		float lon1 = (new Float(Math.toRadians((new Float(point1[1]).doubleValue())))).floatValue();
		float lat2 = (new Float(Math.toRadians((new Float(point2[0]).doubleValue())))).floatValue();
		float lon2 = (new Float(Math.toRadians((new Float(point2[1]).doubleValue())))).floatValue();
		
		float bearing = GreatCircle.spherical_azimuth(lat1, lon1, lat2, lon2);
		
		double bearing12 = (new Float(bearing)).doubleValue();
		
		return bearing12;
	}    	
    
    // calculate the point that's the incr_size from the point given the bearing
    // bearing in radians, point in degrees
    // returns point in degrees
    // distance is incr_size in km
    private float[] calculateDestPoint(float[] point, double bearing) {
    	
    	float lat = (new Float(Math.toRadians((new Float(point[0])).doubleValue()))).floatValue();
    	float lon = (new Float(Math.toRadians((new Float(point[1])).doubleValue()))).floatValue();
    	
    	float dist = (new Float(Geo.kmToAngle(incr_size))).floatValue();
    	
    	LatLonPoint llp = GreatCircle.spherical_between(lat, lon, dist, (new Float(bearing)).floatValue());
    	
    	float[] newpoint = new float[2];
    	
    	newpoint[0] = llp.getLatitude();
    	newpoint[1] = llp.getLongitude();
    	
    	return newpoint;
    }
    
    // checks if start is past end.  This is based on an initalised initdir so we can
    // be assured we are checking the right direction
    private boolean lessThan(float[] start, float[] end, int num) {
    	
    	int dir = 0;
    	
		if (num == 1) dir = initdir1;
		else if (num == 2) dir = initdir2;
		else return false;

		// initdir hasn't been set - find the correct one, set the value, and return true
    	if (dir == 0) {
    		if (start[0] > end[0]) {
    			if (start[1] > end[1]) {
    				dir = 1;
    			} else {
    				dir = 2;
    			}
    		} else {
    			if (start[1] > end[1]) {
    				dir = 3;
    			} else {
    				dir = 4;
    			}
    		}
    		
			if (num == 1) initdir1 = dir;
			else if (num == 2) initdir2 = dir;  
			
			return true;
		}  	
		
		// check according to the dir.
		if (dir == 1 && start[0] > end[0] && start[1] > end[1]) return true;
		if (dir == 2 && start[0] > end[0] && start[1] <= end[1]) return true;
		if (dir == 3 && start[0] <= end[0] && start[1] > end[1]) return true;
		if (dir == 4 && start[0] <= end[0] && start[1] <= end[1]) return true;
			
		return false;
	}
				
	// merges 2 vectors together based on the distance between the start and end points
	// of the 2 vectors.	
	private Vector mergeVectors(Vector v1, Vector v2) {
		
		if (v2.isEmpty()) return v1;
		
		double v1slat = ((Float) v1.firstElement()).doubleValue();
		double v1slon = ((Float) v1.elementAt(1)).doubleValue();
		double v1elat = ((Float) v1.elementAt(v1.size()-2)).doubleValue();
		double v1elon = ((Float) v1.lastElement()).doubleValue();
		double v2slat = ((Float) v2.firstElement()).doubleValue();
		double v2slon = ((Float) v2.elementAt(1)).doubleValue();
		double v2elat = ((Float) v2.elementAt(v2.size()-2)).doubleValue();
		double v2elon = ((Float) v2.lastElement()).doubleValue();
		
		double v1sv2s = Geo.distanceKM(v1slat, v1slon, v2slat, v2slon);
		double v1sv2e = Geo.distanceKM(v1slat, v1slon, v2elat, v2elon);
		double v1ev2s = Geo.distanceKM(v1elat, v1elon, v2slat, v2slon);
		double v1ev2e = Geo.distanceKM(v1elat, v1elon, v2elat, v2elon);
		
		Vector temp = new Vector();
		
		if (v1sv2s > v1sv2e && v1sv2s > v1ev2s && v1sv2s > v1ev2e) {
			// 2 starts are closest
			// reverse v1 to make it v1end to v2start
			for (int k = v1.size() - 1; k >= 0; k--) {
				temp.addElement(v1.elementAt(k));
			}
			
			v2.addAll(v1);
			return v2;
		} else if (v1sv2e > v1sv2s && v1sv2e > v1ev2s && v1sv2e > v1ev2e) {
			// v1 start to v2 end closest
			v2.addAll(v1);
			return (v2);
		} else if (v1ev2s > v1sv2s && v1ev2s > v1sv2e && v1ev2s > v1ev2e) {
			// v2start to v1 end closest
			v1.addAll(v2);
			return (v1);
		} else {
			// v2end to v1 end closest
			// reverse v2 to make it v2 start to v1 end
			for (int k = v2.size() - 1; k >= 0; k--) {
				temp.addElement(v2.elementAt(k));
			}
			
			v1.addAll(v2);
			return v1;
		}
		
	}
    
}